# Day 19: Regular Expressions

## Tasks/Activities:

### Activity 1: Basic Regular Expressions
- **Task 1**: Write a regular expression to match a simple pattern (e.g., match all occurrences of the word "JavaScript" in a string). Log the matches.
- **Task 2**: Write a regular expression to match all digits in a string. Log the matches.

### Activity 2: Character Classes and Quantifiers
- **Task 3**: Write a regular expression to match all words in a string that start with a capital letter. Log the matches.
- **Task 4**: Write a regular expression to match all sequences of one or more digits in a string. Log the matches.

### Activity 3: Grouping and Capturing
- **Task 5**: Write a regular expression to capture the area code, central office code, and line number from a US phone number format (e.g., (123) 456-7890). Log the captures.
- **Task 6**: Write a regular expression to capture the username and domain from an email address. Log the captures.

### Activity 4: Assertions and Boundaries
- **Task 7**: Write a regular expression to match a word only if it is at the beginning of a string. Log the matches.
- **Task 8**: Write a regular expression to match a word only if it is at the end of a string. Log the matches.

### Activity 5: Practical Applications
- **Task 9**: Write a regular expression to validate a simple password (must include at least one uppercase letter, one lowercase letter, one digit, and one special character). Log whether the password is valid.
- **Task 10**: Write a regular expression to validate a URL. Log whether the URL is valid.

## Feature Request:
1. **Basic Regex Script**: Write a script that uses regular expressions to match simple patterns and log the matches.
2. **Character Classes and Quantifiers Script**: Create a script that uses regular expressions to match words with specific characteristics and log the matches.
3. **Grouping and Capturing Script**: Write a script that uses regular expressions to capture parts of a string, such as phone numbers and email addresses, and log the captures.
4. **Assertions and Boundaries Script**: Create a script that uses regular expressions to match words at specific positions in a string and log the matches.
5. **Validation Script**: Write a script that uses regular expressions to validate passwords and URLs and log whether they are valid.

## Achievement:
By the end of these activities, students will:
- Understand and create basic regular expressions.
- Use character classes and quantifiers in regular expressions.
- Implement grouping and capturing in regular expressions.
- Apply assertions and boundaries in regular expressions.
- Use regular expressions for practical applications like validating passwords and URLs.
